* Definicia indexovych mnozin
Sets i /GS,PR,PF,W,NT,E,G,HH,CAP,F/
     l /GJM,ALT/;

alias(i,j)

Set subi(i) /F/
    subj(j) /CAP/;

* Definicia parametrov
Parameters A0(i,j)
           B0(i,j) SAM Year '95,
           X0(j)   column & row sum '95
           A1(i,j)
           B1(i,j) SAM Year '96,
           X1(j)
           Y1(i)   column & row sum '96;

$libinclude xlimport B0 c:\MaxEnt\Data\SAM-95-96.xls data!b4:l14
$libinclude xlimport B1 c:\MaxEnt\Data\SAM-95-96.xls data!b24:l34
$libinclude xlimport X0 c:\MaxEnt\Data\SAM-95-96.xls data!c16:l17
$libinclude xlimport X1 c:\MaxEnt\Data\SAM-95-96.xls data!c36:l37

B0(i,j)=B0(i,j)/1000;
B1(i,j)=B1(i,j)/1000;
x0(j)=x0(j)/1000;
x1(j)=x1(j)/1000;

   A1(i,j)=B1(i,j)/X1(j);

Scalar SH1,SH2;
   SH1=0.0;
   SH2=SH1*X0('F');

   x1('F')=x1('F')+SH2;
   x1('CAP')=x1('CAP')+SH2;

Scalar G1,N1,F;
    G1=sum(j, X1(j));
    N1=sum((i,j), 1);

    F=G1;
*    F=G1/25;
*    F=1;
    G1=G1/F;

    X1(j)=X1(j)/F;

    Y1(i)=X1(i);

Parameter zero(i,j);
$libinclude xlimport zero c:\MaxEnt\Data\SAM-95-96.xls data!b44:l54
zero('F','CAP')$(SH1 ne 0)=0;

* Definicia premennych a rovnic
Variables
   lambda(i)
   mi(j)
   ni(i,j)
   eta
   H       entropy;

Equations
     obj_gjm    define objective function - golan & judge & miller
     obj_alt    define objective function - alternative;

     obj_gjm..    H =e= sum(i, lambda(i)*y1(i))
                      + eta*SH2/F
                      + sum(j, log(sum(i, exp(-lambda(i)*x1(j)
                                              -x1(j)*eta$(subi(i) and subj(j))
                                              -ni(i,j)*zero(i,j)))));
     obj_alt..    H =e= sum(i, lambda(i)*y1(i))
                      + sum(j, mi(j)*x1(j))
                      + eta*SH2/F
                      + log(sum((i,j), exp(-(lambda(i)+mi(j)+ni(i,j)*zero(i,j)+eta$(subi(i) and subj(j)))*G1)));

Model SAM_GJM /obj_gjm/ ;
Model SAM_ALT /obj_alt/ ;

Parameter omega1(j),omega2,A1_HAT(i,j,l),B1_HAT(i,j,l);

* Optimalizacia
option NLP=CONOPT2;

   lambda.l(i)=0;
   mi.l(j)=0;
   ni.l(i,j)=0;
   eta.l=0;

solve SAM_GJM using NLP minimizing H;

   omega1(j)=sum(i, exp(-lambda.l(i)*x1(j)
                        -x1(j)*eta.l$(subi(i) and subj(j))
                        -ni.l(i,j)*zero(i,j)));
   A1_HAT(i,j,'GJM')=exp(-lambda.l(i)*x1(j)
                         -x1(j)*eta.l$(subi(i) and subj(j))
                         -ni.l(i,j)*zero(i,j))/omega1(j);
   B1_HAT(i,j,'GJM')=A1_HAT(i,j,'GJM')*x1(j)*F;

   lambda.l(i)=0;
   mi.l(j)=0;
   ni.l(i,j)=0;
   eta.l=0;

solve SAM_ALT using NLP minimizing H;

   omega2=sum((i,j), exp(-(lambda.l(i)+mi.l(j))*G1
                         -G1*eta.l$(subi(i) and subj(j))
                         -ni.l(i,j)*zero(i,j)));
   A1_HAT(i,j,'ALT')=G1/x1(j)*exp(-(lambda.l(i)+mi.l(j))*G1
                                  -G1*eta.l$(subi(i) and subj(j))
                                  -ni.l(i,j)*zero(i,j))/omega2;
   B1_HAT(i,j,'ALT')=A1_HAT(i,j,'ALT')*x1(j)*F;

x1(j)=x1(j)*F;

B1_HAT('F','CAP',l)=B1_HAT('F','CAP',l)-SH2;
B1_HAT('CAP','F',l)=B1_HAT('CAP','F',l)-SH2;

parameter B1_HAT1(i,j);
B1_HAT1(i,j)=B1_HAT(i,j,'GJM')*1000;
$libinclude xlexport B1_HAT1 C:\MaxEnt\Data\SAM-95-96.xls MEGJM!c4:m14
B1_HAT1(i,j)=B1_HAT(i,j,'ALT')*1000;
$libinclude xlexport B1_HAT1 C:\MaxEnt\Data\SAM-95-96.xls MEALT!c4:m14

x1('F')=x1('F')-SH2;
x1('CAP')=x1('CAP')-SH2;

A1_HAT(i,j,l)=B1_HAT(i,j,l)/X1(j);

Parameter  E_A(i,j,l),E_B(i,j,l),
           P_B(i,j,l);

       E_A(i,j,l) = A1_HAT(i,j,l)-A1(i,j);
       E_B(i,j,l) = B1_HAT(i,j,l)-B1(i,j);
       P_B(i,j,l)$B1(i,j) = abs(E_B(i,j,l))/B1(i,j);

* Vypocet parametrov
Parameter MAD_A(l),SEM_A(l),
          MAD_B(l),SEM_B(l),
          MaxPE(l),MAPE(l),
          GOF_A(l),GOF_B(l),
          CORR_A(l),CORR_B(l),
          mean_A1_HAT(l),mean_A1,
          mean_B1_HAT(l),mean_B1,
          mean0,mean1,
          stddev0,stddev1;

       MAD_A(l) = sum((i,j), abs(E_A(i,j,l)))/N1;
       SEM_A(l) = sum((i,j), power(E_A(i,j,l),2))/N1;

       MAD_B(l) = sum((i,j), abs(E_B(i,j,l)))/N1;
       SEM_B(l) = sum((i,j), power(E_B(i,j,l),2))/N1;

       MaxPE(l) = smax((i,j), P_B(i,j,l));
       MAPE(l) = sum((i,j), P_B(i,j,l))/N1;

       GOF_A(l) = sum((i,j)$A1_HAT(i,j,l), abs(power(E_A(i,j,l),2)/(N1*A1_HAT(i,j,l))));
       mean_A1_HAT(l)=sum((i,j), A1_HAT(i,j,l))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(l) = (sum((i,j),(A1_HAT(i,j,l)-mean_A1_HAT(l))*(A1(i,j)-mean_A1))/N1)/
         (((sum((i,j),power(A1_HAT(i,j,l)-mean_A1_HAT(l),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5);

       GOF_B(l) = sum((i,j)$B1_HAT(i,j,l), abs(power(E_B(i,j,l),2)/(N1*B1_HAT(i,j,l))));
       mean_B1_HAT(l)=sum((i,j), B1_HAT(i,j,l))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(l) = (sum((i,j),(B1_HAT(i,j,l)-mean_B1_HAT(l))*(B1(i,j)-mean_B1))/N1)/
         (((sum((i,j),power(B1_HAT(i,j,l)-mean_B1_HAT(l),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5);

       mean0=sum((i,j), B0(i,j))/N1;
       mean1=sum((i,j), B1(i,j))/N1;
       stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
       stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        stddev0,stddev1;